<?php
// public_html/panel/topup_fancy.php
require_once __DIR__.'/../config/db.php';
require_once __DIR__.'/../config/helpers.php';
require_login();

$err=''; $ok='';
if($_SERVER['REQUEST_METHOD']==='POST'){
  $uid = strtoupper(trim($_POST['uid'] ?? ''));
  $amount = (float)($_POST['amount'] ?? 0);
  if($uid==='' || !preg_match('/^[0-9A-F]+$/',$uid)){ $err='Geçerli bir Kart UID giriniz.'; }
  elseif($amount<=0){ $err='Tutar pozitif olmalıdır.'; }
  else {
    // kart var mı kontrol
    $st = $pdo->prepare("SELECT c.id, a.id AS acc_id, a.name FROM cards c JOIN accounts a ON a.id=c.account_id WHERE c.uid_hex=? LIMIT 1");
    $st->execute([$uid]); $found = $st->fetch();
    if(!$found){ $err='Kart sistemde bulunamadı. Önce Kart Bağla menüsünden tanımlayın.'; }
    else {
      // kuyruğa ekle
      $pdo->prepare("INSERT INTO pending_topups(uid_hex, amount) VALUES(?,?)")->execute([$uid,$amount]);
      $ok = number_format($amount,2).' ₺ yükleme kuyruğa eklendi (' . h($uid) . ').';
    }
  }
}
?><!doctype html>
<html lang="tr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Kredi Yükle</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
  <style>
    .glass{backdrop-filter: blur(6px); background: rgba(255,255,255,.65);}
    .amount-chip{cursor:pointer;border:1px solid #dee2e6;border-radius:10px;padding:.35rem .75rem;display:inline-block;margin:.15rem;}
    .amount-chip:hover{background:#f8f9fa}
    .kbd{border:1px solid #ced4da;border-radius:.5rem;padding:.25rem .5rem;display:inline-block;background:#fff}
    .uid-box{font-family: ui-monospace, SFMono-Regular, Menlo, monospace; letter-spacing: .08em;}
  </style>
</head>
<body class="bg-light">
<div class="container py-4">

  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="mb-0">💳 Kredi Yükleme</h4>
    <div class="d-flex gap-2">
      <a class="btn btn-outline-secondary" href="/panel/uid_live.php">Canlı UID</a>
      <a class="btn btn-outline-dark" href="/panel/index.php">Panele Dön</a>
    </div>
  </div>

  <div class="row g-3">
    <div class="col-lg-7">
      <div class="card shadow-sm">
        <div class="card-body">
          <?php if($err): ?><div class="alert alert-danger"><?=$err?></div><?php endif; ?>
          <?php if($ok): ?><div class="alert alert-success"><?=$ok?></div><?php endif; ?>
          <form method="post" id="frmTopup" onsubmit="return confirm('Kuyruğa eklensin mi?')">
            <div class="mb-3">
              <label class="form-label">Kart UID</label>
              <div class="input-group">
                <input class="form-control uid-box" name="uid" id="uid" placeholder="04AABBCCDDEE" required>
                <button class="btn btn-outline-primary" type="button" onclick="fillLive()">Canlıdan Al</button>
              </div>
              <div class="form-text">Okuyucu HID modundaysa, bu alana odaklanıp kartı okutabilirsiniz.</div>
            </div>

            <div class="mb-3">
              <label class="form-label d-flex justify-content-between">
                <span>Tutar (₺)</span>
                <small>
                  <span class="amount-chip" onclick="setAmt(50)">50</span>
                  <span class="amount-chip" onclick="setAmt(100)">100</span>
                  <span class="amount-chip" onclick="setAmt(250)">250</span>
                  <span class="amount-chip" onclick="setAmt(500)">500</span>
                </small>
              </label>
              <input type="number" step="0.01" min="1" name="amount" id="amount" class="form-control form-control-lg text-end" value="100.00" required>
            </div>

            <div class="d-grid">
              <button class="btn btn-primary btn-lg">Kuyruğa Ekle</button>
            </div>
          </form>
        </div>
      </div>
    </div>

    <div class="col-lg-5">
      <div class="card shadow-sm">
        <div class="card-body">
          <h6 class="text-muted">Kart / Hesap Önizleme</h6>
          <div id="preview" class="small">Kart UID girildiğinde eşleştirilmiş hesap burada görünecek.</div>
        </div>
      </div>
      <div class="card shadow-sm mt-3">
        <div class="card-body">
          <h6 class="text-muted">İpucu</h6>
          <ul class="small mb-0">
            <li><span class="kbd">Canlıdan Al</span> ile son okutulan UID otomatik gelir.</li>
            <li>Tüm yüklemeler <b>kuyruğa</b> düşer, <i>Sync Agent</i> SQL Server'a uygular.</li>
          </ul>
        </div>
      </div>
    </div>
  </div>
</div>
<script>
async function fillLive(){
  const r = await fetch('/api/uid/last.php',{cache:'no-store'});
  const j = await r.json();
  if(j.uid){ document.getElementById('uid').value = j.uid; onUidInput(); }
}
function setAmt(v){ const a=document.getElementById('amount'); a.value = Number(v).toFixed(2); }
let t=null;
document.getElementById('uid').addEventListener('input', onUidInput);
async function onUidInput(){
  clearTimeout(t);
  t=setTimeout(async()=>{
    const uid = document.getElementById('uid').value.trim();
    if(!uid) { document.getElementById('preview').innerHTML=''; return; }
    const r = await fetch('/api/topup/resolve_uid.php?uid='+encodeURIComponent(uid));
    const j = await r.json();
    if(j.ok && j.account){
      document.getElementById('preview').innerHTML = '<div><b>Hesap:</b> '+(j.account.name||'-')+'</div><div><b>Durum:</b> '+(j.account.status||'-')+'</div>';
    }else{
      document.getElementById('preview').innerHTML = '<span class="text-danger">Kart eşleşmesi bulunamadı.</span>';
    }
  }, 300);
}
</script>
</body>
</html>
